# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TaskPySparkBuild(UniversalBaseModel):
    """
    Describes the configuration for the PySpark build for a task
    """

    type: typing.Literal["task-pyspark-build"] = pydantic.Field(default="task-pyspark-build")
    """
    +value=task-pyspark-build
    """

    spark_version: str = pydantic.Field(default="3.5.2")
    """
    Spark version should match the spark version installed in the image.
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    requirements_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    Path to `requirements.txt` relative to
    `Path to build context`
    """

    pip_packages: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Define pip package requirements.
    In Python/YAML E.g. ["fastapi>=0.90,<1.0", "uvicorn"]
    """

    apt_packages: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Debian packages to install via `apt get`.
    In Python/YAML E.g. ["git", "ffmpeg", "htop"]
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
