# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class TaskPythonBuild(UniversalBaseModel):
    """
    Describes the configuration for the python build for a task
    """

    type: typing.Literal["task-python-build"] = pydantic.Field(default="task-python-build")
    """
    +value=task-python-build
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    python_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    Python version to run your application. Should be one of the tags listed on [Official Python Docker Page](https://hub.docker.com/_/python)
    """

    requirements_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    Path to `requirements.txt` relative to
    `Path to build context`
    """

    pip_packages: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Define pip package requirements.
    In Python/YAML E.g. ["fastapi>=0.90,<1.0", "uvicorn"]
    """

    apt_packages: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Debian packages to install via `apt get`.
    In Python/YAML E.g. ["git", "ffmpeg", "htop"]
    """

    cuda_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    Version of CUDA Toolkit and CUDNN to install in the image
    These combinations are based off of publically available docker images on docker hub
    You can also specify a valid tag of the form {cuda_version_number}-cudnn{cudnn_version_number}-{runtime|devel}-ubuntu{ubuntu_version}
    Refer https://hub.docker.com/r/nvidia/cuda/tags for valid set of values
    Note: We use deadsnakes ubuntu ppa to add Python that currently supports only Ubuntu 18.04, 20.04 and 22.04
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
