# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .subject import Subject
from .team_manifest import TeamManifest


class Team(UniversalBaseModel):
    id: str
    team_name: typing_extensions.Annotated[str, FieldMetadata(alias="teamName")]
    description: str
    tenant_name: typing_extensions.Annotated[str, FieldMetadata(alias="tenantName")]
    account_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="accountId")] = None
    created_by_subject: typing_extensions.Annotated[Subject, FieldMetadata(alias="createdBySubject")]
    members: typing.Optional[typing.List[str]] = None
    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")]
    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")]
    manifest: TeamManifest

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
