# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .team_owned_by import TeamOwnedBy


class TeamManifest(UniversalBaseModel):
    type: typing.Literal["team"] = pydantic.Field(default="team")
    """
    +value=team
    """

    name: str = pydantic.Field()
    """
    Name of the Team
    """

    managers: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Emails of each of the user who can manage the members of the team. Any tenant admin is by default a team manager.
    """

    members: typing.List[str] = pydantic.Field()
    """
    Enter email of each of the user you want to add in the team.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[TeamOwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
