# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .owned_by import OwnedBy
from .together_ai_integrations import TogetherAiIntegrations
from .together_ai_key_auth import TogetherAiKeyAuth


class TogetherAiProviderAccount(UniversalBaseModel):
    """
    Together AI Provider Account
    """

    type: typing.Literal["provider-account/together-ai"] = pydantic.Field(default="provider-account/together-ai")
    """
    +value=provider-account/together-ai
    """

    name: str = pydantic.Field()
    """
    The name of the Together AI provider account
    """

    auth_data: TogetherAiKeyAuth
    integrations: typing.List[TogetherAiIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the Together AI provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
