# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .library_name import LibraryName


class TransformersFramework(UniversalBaseModel):
    type: typing.Literal["transformers"] = pydantic.Field(default="transformers")
    """
    Type of the framework
    """

    library_name: typing.Optional[LibraryName] = pydantic.Field(default=None)
    """
    Name of the library for the framework
    """

    pipeline_tag: typing.Optional[str] = pydantic.Field(default=None)
    """
    The `pipeline()` task this model can be used with e.g. `text-generation`. See [huggingface docs](https://huggingface.co/docs/transformers/main/en/main_classes/pipelines#transformers.pipeline.task) for all possible values
    """

    base_model: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base model Id from HuggingFace Hub. If this is a finetuned model, this points to the base model id used for finetuning.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
