# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .user_message_content import UserMessageContent


class UserMessage(UniversalBaseModel):
    """
    User message turn
    """

    role: typing.Literal["user"] = pydantic.Field(default="user")
    """
    Role of the message
    """

    content: UserMessageContent = pydantic.Field()
    """
    Content of the user message. can be a mix of text and images
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the user this message is from
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
