# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .gcp_region import GcpRegion
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class VertexModel(UniversalBaseModel):
    """
    Vertex Model
    """

    type: typing.Literal["integration/model/vertex"] = pydantic.Field(default="integration/model/vertex")
    """
    +value=integration/model/vertex
    """

    name: str = pydantic.Field()
    """
    A descriptive name to identify this model integration in the UI
    """

    model_id: str = pydantic.Field()
    """
    The Google Vertex AI model identifier (e.g., gemini-2.5-pro, anthropic/claude-sonnet-4-5@20250929). This is the model version name from Vertex AI's model catalog.
    """

    region: typing.Optional[GcpRegion] = None
    model_types: typing.List[ModelType] = pydantic.Field()
    """
    Specify the type of the Vertex AI model (e.g., chat, text, etc.)
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
