# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .virtual_mcp_server_source import VirtualMcpServerSource


class VirtualMcpServerIntegration(UniversalBaseModel):
    """
    Virtual MCP Server
    """

    type: typing.Literal["integration/mcp-server/virtual"] = pydantic.Field(default="integration/mcp-server/virtual")
    """
    +value=integration/mcp-server/virtual
    """

    name: str = pydantic.Field()
    """
    The name of the Virtual MCP Server.
    """

    description: str = pydantic.Field()
    """
    Provide a brief description of the purpose of this Virtual MCP Server.
    """

    servers: typing.List[VirtualMcpServerSource] = pydantic.Field()
    """
    List of source MCP servers to include in this virtual server.
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of teams/users who can use this MCP server.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
