# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .endpoint import Endpoint


class VolumeBrowser(UniversalBaseModel):
    """
    Volume Browser
    """

    username: typing.Optional[str] = pydantic.Field(default=None)
    """
    Username for logging in the volume browser.
    """

    password_secret_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    TFY Secret containing the password for logging in the volume browser.
    """

    endpoint: Endpoint
    service_account: typing.Optional[str] = pydantic.Field(default=None)
    """
    Kubernetes Service account name for the volume browser.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
