# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .webhook_integration_auth_data import WebhookIntegrationAuthData


class WebhookIntegration(UniversalBaseModel):
    """
    Webhook Integration
    """

    type: typing.Literal["integration/gateway-request-logger/webhook"] = pydantic.Field(
        default="integration/gateway-request-logger/webhook"
    )
    """
    +value=integration/gateway-request-logger/webhook
    """

    name: str = pydantic.Field()
    """
    The name of the integration that will be displayed in the TrueFoundry UI.
    """

    webhook_url: str = pydantic.Field()
    """
    The URL of the webhook endpoint
    """

    auth_data: typing.Optional[WebhookIntegrationAuthData] = pydantic.Field(default=None)
    """
    Authentication configuration for the webhook
    """

    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
