# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .owned_by import OwnedBy
from .webhook_integrations import WebhookIntegrations


class WebhookProviderAccount(UniversalBaseModel):
    """
    Webhook Provider Account
    """

    type: typing.Literal["provider-account/webhook"] = pydantic.Field(default="provider-account/webhook")
    """
    +value=provider-account/webhook
    """

    name: str = pydantic.Field()
    """
    The name of the provider account.
    """

    integrations: typing.List[WebhookIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the provider account.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
