# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class WorkbenchImage(UniversalBaseModel):
    """
    Workbench Image with persistent environment (Python 3.11.6)
    """

    image_uri: str = pydantic.Field()
    """
    The image URI. Specify the name of the image and the tag.
    If the image is in Dockerhub, you can skip registry-url (for e.g. `tensorflow/tensorflow`).
    You can use an image from a private registry using Advanced fields
    """

    build_script: typing.Optional[str] = pydantic.Field(default=None)
    """
    The build script to run when building the image.
    This will be executed as the last step in the docker build process as the root user (RUN DEBIAN_FRONTEND=noninteractive bash -ex build_script.sh)
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
