# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .workflow_alert import WorkflowAlert
from .workflow_flyte_entities_item import WorkflowFlyteEntitiesItem
from .workflow_source import WorkflowSource


class Workflow(UniversalBaseModel):
    """
    Describes the configuration for the worflow
    """

    type: typing.Literal["workflow"] = pydantic.Field(default="workflow")
    """
    +value=workflow
    """

    name: str = pydantic.Field()
    """
    Name of the workflow
    """

    source: WorkflowSource = pydantic.Field()
    """
    Source Code for the workflow, either local or remote
    """

    workflow_file_path: str = pydantic.Field()
    """
    Path to the workflow file relative to the project root path
    """

    flyte_entities: typing.Optional[typing.List[WorkflowFlyteEntitiesItem]] = pydantic.Field(default=None)
    """
    Flyte Entities
    """

    alerts: typing.Optional[typing.List[WorkflowAlert]] = pydantic.Field(default=None)
    """
    Alerts
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
