# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .owned_by import OwnedBy
from .permissions import Permissions


class WorkspaceManifest(UniversalBaseModel):
    type: typing.Literal["workspace"] = pydantic.Field(default="workspace")
    """
    +value=workspace
    """

    cluster_fqn: str = pydantic.Field()
    """
    Cluster FQN
    """

    name: str = pydantic.Field()
    """
    Name - 3 to 32 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    environment_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Tag the environment like dev, staging or production. You will need to [create environments](https://docs.truefoundry.com/docs/key-concepts#creating-environments) if you don't have already.
    """

    labels: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    +sort=700
    """

    annotations: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    +sort=750
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    Collaborators
    """

    permissions: typing.Optional[typing.List[Permissions]] = pydantic.Field(default=None)
    """
    Permissions
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
