# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.activate_user_response import ActivateUserResponse
from ..types.change_password_response import ChangePasswordResponse
from ..types.deactivate_user_response import DeactivateUserResponse
from ..types.delete_user_response import DeleteUserResponse
from ..types.get_user_resources_response import GetUserResourcesResponse
from ..types.get_user_response import GetUserResponse
from ..types.get_user_teams_response import GetUserTeamsResponse
from ..types.invite_user_response import InviteUserResponse
from ..types.register_users_response import RegisterUsersResponse
from ..types.update_user_roles_response import UpdateUserRolesResponse
from ..types.user import User
from .raw_client import AsyncRawUsersClient, RawUsersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUsersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUsersClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        query: typing.Optional[str] = None,
        show_invalid_users: typing.Optional[bool] = None,
        include_virtual_accounts: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[User]:
        """
        List all users of tenant filtered by query and showInvalidUsers. Pagination is available based on query parameters.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        query : typing.Optional[str]

        show_invalid_users : typing.Optional[bool]
            Show Deactivated users

        include_virtual_accounts : typing.Optional[str]
            Include virtual accounts

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[User]
            Returns all users of tenant and also the response includes paginated data.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.users.list(
            limit=10,
            offset=0,
            query="query",
            show_invalid_users=True,
            include_virtual_accounts="includeVirtualAccounts",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            limit=limit,
            offset=offset,
            query=query,
            show_invalid_users=show_invalid_users,
            include_virtual_accounts=include_virtual_accounts,
            request_options=request_options,
        )

    def pre_register_users(
        self,
        *,
        email: str,
        send_invite_email: typing.Optional[bool] = False,
        skip_if_user_exists: typing.Optional[bool] = False,
        dry_run: typing.Optional[bool] = False,
        accept_invite_client_url: typing.Optional[str] = OMIT,
        account_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RegisterUsersResponse:
        """
        This endpoint allows tenant administrators to register users within their tenant.

        Parameters
        ----------
        email : str
            Email of the user

        send_invite_email : typing.Optional[bool]
            Send invite email if user does not exist

        skip_if_user_exists : typing.Optional[bool]
            Fail if user exists

        dry_run : typing.Optional[bool]
            Dry run

        accept_invite_client_url : typing.Optional[str]
            Url to redirect when invite is accepted

        account_id : typing.Optional[str]
            Account ID to add the user to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RegisterUsersResponse
            The users have been successfully registered.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.users.pre_register_users(
            email="email",
        )
        """
        _response = self._raw_client.pre_register_users(
            email=email,
            send_invite_email=send_invite_email,
            skip_if_user_exists=skip_if_user_exists,
            dry_run=dry_run,
            accept_invite_client_url=accept_invite_client_url,
            account_id=account_id,
            request_options=request_options,
        )
        return _response.data

    def update_roles(
        self, *, email: str, roles: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> UpdateUserRolesResponse:
        """
        This endpoint allows tenant administrators to update the roles of a user within their tenant.

        Parameters
        ----------
        email : str
            Email of the user

        roles : typing.Sequence[str]
            Roles for the user

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateUserRolesResponse
            The user roles have been successfully updated.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.users.update_roles(
            email="email",
            roles=["roles"],
        )
        """
        _response = self._raw_client.update_roles(email=email, roles=roles, request_options=request_options)
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetUserResponse:
        """
        Get User associated with provided User id

        Parameters
        ----------
        id : str
            User Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserResponse
            Returns the User associated with provided User id

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.users.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DeleteUserResponse:
        """
        Delete user if they are not a collaborator in any resource and not part of any team other than everyone.

        Parameters
        ----------
        id : str
            User Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteUserResponse
            User has been successfully deleted.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.users.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def invite_user(
        self,
        *,
        accept_invite_client_url: str,
        email: str,
        account_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InviteUserResponse:
        """
        Invite a user to the tenant

        Parameters
        ----------
        accept_invite_client_url : str
            Url to redirect when invite is accepted

        email : str
            Email of user

        account_id : typing.Optional[str]
            Account ID to add the user to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InviteUserResponse
            User has been successfully invited.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.users.invite_user(
            accept_invite_client_url="<control plane url>/invite-accept",
            email="email",
        )
        """
        _response = self._raw_client.invite_user(
            accept_invite_client_url=accept_invite_client_url,
            email=email,
            account_id=account_id,
            request_options=request_options,
        )
        return _response.data

    def deactivate(
        self, *, email: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DeactivateUserResponse:
        """
        Deactivate user associated with the provided email within the tenant.

        Parameters
        ----------
        email : str
            Email of the user

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeactivateUserResponse
            User has been successfully deactivated.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.users.deactivate(
            email="email",
        )
        """
        _response = self._raw_client.deactivate(email=email, request_options=request_options)
        return _response.data

    def activate(self, *, email: str, request_options: typing.Optional[RequestOptions] = None) -> ActivateUserResponse:
        """
        Activate user associated with the provided email within the tenant.

        Parameters
        ----------
        email : str
            Email of the user

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActivateUserResponse
            User has been successfully activated.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.users.activate(
            email="email",
        )
        """
        _response = self._raw_client.activate(email=email, request_options=request_options)
        return _response.data

    def change_password(
        self,
        *,
        login_id: str,
        new_password: str,
        old_password: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChangePasswordResponse:
        """
        Change password for the authenticated user. Requires clientId and loginId in the request body.

        Parameters
        ----------
        login_id : str
            login id of the user(email)

        new_password : str
            New password

        old_password : str
            Old password

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChangePasswordResponse
            Password has been changed successfully.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.users.change_password(
            login_id="loginId",
            new_password="newPassword",
            old_password="oldPassword",
        )
        """
        _response = self._raw_client.change_password(
            login_id=login_id, new_password=new_password, old_password=old_password, request_options=request_options
        )
        return _response.data

    def get_resources(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserResourcesResponse:
        """
        Get all resources associated with a user.

        Parameters
        ----------
        id : str
            User Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserResourcesResponse
            Returns all resources for the user.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.users.get_resources(
            id="id",
        )
        """
        _response = self._raw_client.get_resources(id, request_options=request_options)
        return _response.data

    def get_teams(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetUserTeamsResponse:
        """
        Get all manual teams associated with a user.

        Parameters
        ----------
        id : str
            User Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserTeamsResponse
            Returns all manual teams for the user.

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.users.get_teams(
            id="id",
        )
        """
        _response = self._raw_client.get_teams(id, request_options=request_options)
        return _response.data


class AsyncUsersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUsersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUsersClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        query: typing.Optional[str] = None,
        show_invalid_users: typing.Optional[bool] = None,
        include_virtual_accounts: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[User]:
        """
        List all users of tenant filtered by query and showInvalidUsers. Pagination is available based on query parameters.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        query : typing.Optional[str]

        show_invalid_users : typing.Optional[bool]
            Show Deactivated users

        include_virtual_accounts : typing.Optional[str]
            Include virtual accounts

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[User]
            Returns all users of tenant and also the response includes paginated data.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.users.list(
                limit=10,
                offset=0,
                query="query",
                show_invalid_users=True,
                include_virtual_accounts="includeVirtualAccounts",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            limit=limit,
            offset=offset,
            query=query,
            show_invalid_users=show_invalid_users,
            include_virtual_accounts=include_virtual_accounts,
            request_options=request_options,
        )

    async def pre_register_users(
        self,
        *,
        email: str,
        send_invite_email: typing.Optional[bool] = False,
        skip_if_user_exists: typing.Optional[bool] = False,
        dry_run: typing.Optional[bool] = False,
        accept_invite_client_url: typing.Optional[str] = OMIT,
        account_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RegisterUsersResponse:
        """
        This endpoint allows tenant administrators to register users within their tenant.

        Parameters
        ----------
        email : str
            Email of the user

        send_invite_email : typing.Optional[bool]
            Send invite email if user does not exist

        skip_if_user_exists : typing.Optional[bool]
            Fail if user exists

        dry_run : typing.Optional[bool]
            Dry run

        accept_invite_client_url : typing.Optional[str]
            Url to redirect when invite is accepted

        account_id : typing.Optional[str]
            Account ID to add the user to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RegisterUsersResponse
            The users have been successfully registered.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.users.pre_register_users(
                email="email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.pre_register_users(
            email=email,
            send_invite_email=send_invite_email,
            skip_if_user_exists=skip_if_user_exists,
            dry_run=dry_run,
            accept_invite_client_url=accept_invite_client_url,
            account_id=account_id,
            request_options=request_options,
        )
        return _response.data

    async def update_roles(
        self, *, email: str, roles: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> UpdateUserRolesResponse:
        """
        This endpoint allows tenant administrators to update the roles of a user within their tenant.

        Parameters
        ----------
        email : str
            Email of the user

        roles : typing.Sequence[str]
            Roles for the user

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateUserRolesResponse
            The user roles have been successfully updated.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.users.update_roles(
                email="email",
                roles=["roles"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_roles(email=email, roles=roles, request_options=request_options)
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetUserResponse:
        """
        Get User associated with provided User id

        Parameters
        ----------
        id : str
            User Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserResponse
            Returns the User associated with provided User id

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.users.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> DeleteUserResponse:
        """
        Delete user if they are not a collaborator in any resource and not part of any team other than everyone.

        Parameters
        ----------
        id : str
            User Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteUserResponse
            User has been successfully deleted.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.users.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def invite_user(
        self,
        *,
        accept_invite_client_url: str,
        email: str,
        account_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InviteUserResponse:
        """
        Invite a user to the tenant

        Parameters
        ----------
        accept_invite_client_url : str
            Url to redirect when invite is accepted

        email : str
            Email of user

        account_id : typing.Optional[str]
            Account ID to add the user to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InviteUserResponse
            User has been successfully invited.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.users.invite_user(
                accept_invite_client_url="<control plane url>/invite-accept",
                email="email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.invite_user(
            accept_invite_client_url=accept_invite_client_url,
            email=email,
            account_id=account_id,
            request_options=request_options,
        )
        return _response.data

    async def deactivate(
        self, *, email: str, request_options: typing.Optional[RequestOptions] = None
    ) -> DeactivateUserResponse:
        """
        Deactivate user associated with the provided email within the tenant.

        Parameters
        ----------
        email : str
            Email of the user

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeactivateUserResponse
            User has been successfully deactivated.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.users.deactivate(
                email="email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deactivate(email=email, request_options=request_options)
        return _response.data

    async def activate(
        self, *, email: str, request_options: typing.Optional[RequestOptions] = None
    ) -> ActivateUserResponse:
        """
        Activate user associated with the provided email within the tenant.

        Parameters
        ----------
        email : str
            Email of the user

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ActivateUserResponse
            User has been successfully activated.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.users.activate(
                email="email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.activate(email=email, request_options=request_options)
        return _response.data

    async def change_password(
        self,
        *,
        login_id: str,
        new_password: str,
        old_password: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChangePasswordResponse:
        """
        Change password for the authenticated user. Requires clientId and loginId in the request body.

        Parameters
        ----------
        login_id : str
            login id of the user(email)

        new_password : str
            New password

        old_password : str
            Old password

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChangePasswordResponse
            Password has been changed successfully.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.users.change_password(
                login_id="loginId",
                new_password="newPassword",
                old_password="oldPassword",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.change_password(
            login_id=login_id, new_password=new_password, old_password=old_password, request_options=request_options
        )
        return _response.data

    async def get_resources(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserResourcesResponse:
        """
        Get all resources associated with a user.

        Parameters
        ----------
        id : str
            User Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserResourcesResponse
            Returns all resources for the user.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.users.get_resources(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_resources(id, request_options=request_options)
        return _response.data

    async def get_teams(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUserTeamsResponse:
        """
        Get all manual teams associated with a user.

        Parameters
        ----------
        id : str
            User Id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUserTeamsResponse
            Returns all manual teams for the user.

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.users.get_teams(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_teams(id, request_options=request_options)
        return _response.data
