# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.delete_virtual_account_response import DeleteVirtualAccountResponse
from ..types.get_token_for_virtual_account_response import GetTokenForVirtualAccountResponse
from ..types.get_virtual_account_response import GetVirtualAccountResponse
from ..types.sync_virtual_account_token_response import SyncVirtualAccountTokenResponse
from ..types.virtual_account import VirtualAccount
from ..types.virtual_account_manifest import VirtualAccountManifest
from .raw_client import AsyncRawVirtualAccountsClient, RawVirtualAccountsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VirtualAccountsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVirtualAccountsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVirtualAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVirtualAccountsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[VirtualAccount]:
        """
        List virtual accounts for the tenant.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[VirtualAccount]
            Return all virtual accounts for the tenant

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        response = client.virtual_accounts.list(
            limit=10,
            offset=0,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(limit=limit, offset=offset, request_options=request_options)

    def create_or_update(
        self,
        *,
        manifest: VirtualAccountManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetVirtualAccountResponse:
        """
        Creates a new virtual account or updates an existing one based on the provided manifest.

        Parameters
        ----------
        manifest : VirtualAccountManifest
            Virtual account manifest

        dry_run : typing.Optional[bool]
            Dry run

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetVirtualAccountResponse
            Virtual account created/updated successfully

        Examples
        --------
        from truefoundry_sdk import Permissions, TrueFoundry, VirtualAccountManifest

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.virtual_accounts.create_or_update(
            manifest=VirtualAccountManifest(
                name="name",
                permissions=[
                    Permissions(
                        resource_fqn="resource_fqn",
                        resource_type="resource_type",
                        role_id="role_id",
                    )
                ],
            ),
        )
        """
        _response = self._raw_client.create_or_update(
            manifest=manifest, dry_run=dry_run, request_options=request_options
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetVirtualAccountResponse:
        """
        Get virtual account by id

        Parameters
        ----------
        id : str
            serviceaccount id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetVirtualAccountResponse
            Returns the virtual account associated with the provided virtual account id

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.virtual_accounts.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteVirtualAccountResponse:
        """
        Delete a virtual account associated with the provided virtual account id.

        Parameters
        ----------
        id : str
            serviceaccount id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteVirtualAccountResponse
            Virtual account deleted successfully

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.virtual_accounts.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def get_token(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTokenForVirtualAccountResponse:
        """
        Get token for a virtual account by id

        Parameters
        ----------
        id : str
            serviceaccount id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTokenForVirtualAccountResponse
            Token for the virtual account

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.virtual_accounts.get_token(
            id="id",
        )
        """
        _response = self._raw_client.get_token(id, request_options=request_options)
        return _response.data

    def sync_to_secret_store(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SyncVirtualAccountTokenResponse:
        """
        Syncs the virtual account token to the configured secret store. Returns the updated JWT with sync metadata including timestamp and error (if any).

        Parameters
        ----------
        id : str
            serviceaccount id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncVirtualAccountTokenResponse
            Token synced successfully to secret store

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.virtual_accounts.sync_to_secret_store(
            id="id",
        )
        """
        _response = self._raw_client.sync_to_secret_store(id, request_options=request_options)
        return _response.data

    def regenerate_token(
        self, id: str, *, grace_period_in_days: float, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTokenForVirtualAccountResponse:
        """
        Regenerate token for a virtual account by id. The old token will remain valid for the specified grace period.

        Parameters
        ----------
        id : str
            serviceaccount id

        grace_period_in_days : float
            Grace period in days for which the old token will remain valid after regeneration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTokenForVirtualAccountResponse
            Token for the virtual account

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.virtual_accounts.regenerate_token(
            id="id",
            grace_period_in_days=30.0,
        )
        """
        _response = self._raw_client.regenerate_token(
            id, grace_period_in_days=grace_period_in_days, request_options=request_options
        )
        return _response.data

    def delete_jwt(self, id: str, jwt_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a JWT for a virtual account by id

        Parameters
        ----------
        id : str
            virtual account id

        jwt_id : str
            JWT id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from truefoundry_sdk import TrueFoundry

        client = TrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )
        client.virtual_accounts.delete_jwt(
            id="id",
            jwt_id="jwtId",
        )
        """
        _response = self._raw_client.delete_jwt(id, jwt_id, request_options=request_options)
        return _response.data


class AsyncVirtualAccountsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVirtualAccountsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVirtualAccountsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVirtualAccountsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = 100,
        offset: typing.Optional[int] = 0,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[VirtualAccount]:
        """
        List virtual accounts for the tenant.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of items per page

        offset : typing.Optional[int]
            Number of items to skip

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[VirtualAccount]
            Return all virtual accounts for the tenant

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            response = await client.virtual_accounts.list(
                limit=10,
                offset=0,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(limit=limit, offset=offset, request_options=request_options)

    async def create_or_update(
        self,
        *,
        manifest: VirtualAccountManifest,
        dry_run: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetVirtualAccountResponse:
        """
        Creates a new virtual account or updates an existing one based on the provided manifest.

        Parameters
        ----------
        manifest : VirtualAccountManifest
            Virtual account manifest

        dry_run : typing.Optional[bool]
            Dry run

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetVirtualAccountResponse
            Virtual account created/updated successfully

        Examples
        --------
        import asyncio

        from truefoundry_sdk import (
            AsyncTrueFoundry,
            Permissions,
            VirtualAccountManifest,
        )

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.virtual_accounts.create_or_update(
                manifest=VirtualAccountManifest(
                    name="name",
                    permissions=[
                        Permissions(
                            resource_fqn="resource_fqn",
                            resource_type="resource_type",
                            role_id="role_id",
                        )
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update(
            manifest=manifest, dry_run=dry_run, request_options=request_options
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetVirtualAccountResponse:
        """
        Get virtual account by id

        Parameters
        ----------
        id : str
            serviceaccount id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetVirtualAccountResponse
            Returns the virtual account associated with the provided virtual account id

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.virtual_accounts.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteVirtualAccountResponse:
        """
        Delete a virtual account associated with the provided virtual account id.

        Parameters
        ----------
        id : str
            serviceaccount id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteVirtualAccountResponse
            Virtual account deleted successfully

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.virtual_accounts.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def get_token(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTokenForVirtualAccountResponse:
        """
        Get token for a virtual account by id

        Parameters
        ----------
        id : str
            serviceaccount id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTokenForVirtualAccountResponse
            Token for the virtual account

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.virtual_accounts.get_token(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_token(id, request_options=request_options)
        return _response.data

    async def sync_to_secret_store(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SyncVirtualAccountTokenResponse:
        """
        Syncs the virtual account token to the configured secret store. Returns the updated JWT with sync metadata including timestamp and error (if any).

        Parameters
        ----------
        id : str
            serviceaccount id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncVirtualAccountTokenResponse
            Token synced successfully to secret store

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.virtual_accounts.sync_to_secret_store(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.sync_to_secret_store(id, request_options=request_options)
        return _response.data

    async def regenerate_token(
        self, id: str, *, grace_period_in_days: float, request_options: typing.Optional[RequestOptions] = None
    ) -> GetTokenForVirtualAccountResponse:
        """
        Regenerate token for a virtual account by id. The old token will remain valid for the specified grace period.

        Parameters
        ----------
        id : str
            serviceaccount id

        grace_period_in_days : float
            Grace period in days for which the old token will remain valid after regeneration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTokenForVirtualAccountResponse
            Token for the virtual account

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.virtual_accounts.regenerate_token(
                id="id",
                grace_period_in_days=30.0,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.regenerate_token(
            id, grace_period_in_days=grace_period_in_days, request_options=request_options
        )
        return _response.data

    async def delete_jwt(
        self, id: str, jwt_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete a JWT for a virtual account by id

        Parameters
        ----------
        id : str
            virtual account id

        jwt_id : str
            JWT id

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from truefoundry_sdk import AsyncTrueFoundry

        client = AsyncTrueFoundry(
            api_key="YOUR_API_KEY",
            base_url="https://yourhost.com/path/to/api",
        )


        async def main() -> None:
            await client.virtual_accounts.delete_jwt(
                id="id",
                jwt_id="jwtId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_jwt(id, jwt_id, request_options=request_options)
        return _response.data
