"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ApplePayHeaderTypedDict(TypedDict):
    r"""Information needed to decrypt Apple Pay payment data.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/passkit/payment-token-format-reference#Header-keys-and-values)
    for more information.
    """

    public_key_hash: str
    r"""A base64-encoded, SHA-256 hash of the merchant's public key."""
    transaction_id: str
    r"""A device-generated identifier for the transaction."""
    ephemeral_public_key: NotRequired[str]
    r"""Base64-encoded ephemeral public key, used for ECC-encrypted payment data."""


class ApplePayHeader(BaseModel):
    r"""Information needed to decrypt Apple Pay payment data.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/passkit/payment-token-format-reference#Header-keys-and-values)
    for more information.
    """

    public_key_hash: Annotated[str, pydantic.Field(alias="publicKeyHash")]
    r"""A base64-encoded, SHA-256 hash of the merchant's public key."""

    transaction_id: Annotated[str, pydantic.Field(alias="transactionId")]
    r"""A device-generated identifier for the transaction."""

    ephemeral_public_key: Annotated[
        Optional[str], pydantic.Field(alias="ephemeralPublicKey")
    ] = None
    r"""Base64-encoded ephemeral public key, used for ECC-encrypted payment data."""
