"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from decimal import Decimal
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import serialize_decimal, validate_decimal
import pydantic
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import BeforeValidator
from typing_extensions import Annotated, TypedDict


class BillingInterchangeProgramFeeTypedDict(TypedDict):
    r"""Details of a specific interchange program fee."""

    program_name: str
    r"""The name of the interchange program."""
    count: int
    r"""The number of transactions for this program."""
    percentage_rate: Decimal
    r"""The percentage rate for this program."""
    per_item_rate: AmountDecimalTypedDict
    r"""The per-item rate for this program."""
    total: AmountDecimalTypedDict
    r"""The total fee amount for this program."""
    transfer_volume: AmountDecimalTypedDict
    r"""The total transfer volume for this program."""


class BillingInterchangeProgramFee(BaseModel):
    r"""Details of a specific interchange program fee."""

    program_name: Annotated[str, pydantic.Field(alias="programName")]
    r"""The name of the interchange program."""

    count: int
    r"""The number of transactions for this program."""

    percentage_rate: Annotated[
        Annotated[
            Decimal,
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="percentageRate"),
    ]
    r"""The percentage rate for this program."""

    per_item_rate: Annotated[AmountDecimal, pydantic.Field(alias="perItemRate")]
    r"""The per-item rate for this program."""

    total: AmountDecimal
    r"""The total fee amount for this program."""

    transfer_volume: Annotated[AmountDecimal, pydantic.Field(alias="transferVolume")]
    r"""The total transfer volume for this program."""
