"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardtransactionfailurecode import CardTransactionFailureCode
from .cardtransactionstatus import CardTransactionStatus
from .transactionsource import TransactionSource
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CardTransactionDetailsTypedDict(TypedDict):
    r"""Card-specific details about the transaction."""

    status: CardTransactionStatus
    r"""Status of a transaction within the card payment lifecycle."""
    failure_code: NotRequired[CardTransactionFailureCode]
    dynamic_descriptor: NotRequired[str]
    r"""An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field."""
    transaction_source: NotRequired[TransactionSource]
    r"""Specifies the nature and initiator of a transaction.

    Crucial for recurring and merchant-initiated transactions as per card scheme rules.
    Omit for customer-initiated e-commerce transactions.
    """
    initiated_on: NotRequired[datetime]
    confirmed_on: NotRequired[datetime]
    settled_on: NotRequired[datetime]
    failed_on: NotRequired[datetime]
    canceled_on: NotRequired[datetime]
    completed_on: NotRequired[datetime]
    interchange_qualification: NotRequired[str]
    r"""The program assigned by the card network that determines the interchange rate for the transfer."""
    fee_program: NotRequired[str]
    r"""The program assigned by the card network that determines the interchange rate for the transfer."""
    authorization_code: NotRequired[str]
    r"""An alphanumeric code generated by the card network to demonstrate approval for the transaction."""


class CardTransactionDetails(BaseModel):
    r"""Card-specific details about the transaction."""

    status: CardTransactionStatus
    r"""Status of a transaction within the card payment lifecycle."""

    failure_code: Annotated[
        Optional[CardTransactionFailureCode], pydantic.Field(alias="failureCode")
    ] = None

    dynamic_descriptor: Annotated[
        Optional[str], pydantic.Field(alias="dynamicDescriptor")
    ] = None
    r"""An optional override of the default card statement descriptor for a transfer. Accounts must be enabled by Moov to set this field."""

    transaction_source: Annotated[
        Optional[TransactionSource], pydantic.Field(alias="transactionSource")
    ] = None
    r"""Specifies the nature and initiator of a transaction.

    Crucial for recurring and merchant-initiated transactions as per card scheme rules.
    Omit for customer-initiated e-commerce transactions.
    """

    initiated_on: Annotated[Optional[datetime], pydantic.Field(alias="initiatedOn")] = (
        None
    )

    confirmed_on: Annotated[Optional[datetime], pydantic.Field(alias="confirmedOn")] = (
        None
    )

    settled_on: Annotated[Optional[datetime], pydantic.Field(alias="settledOn")] = None

    failed_on: Annotated[Optional[datetime], pydantic.Field(alias="failedOn")] = None

    canceled_on: Annotated[Optional[datetime], pydantic.Field(alias="canceledOn")] = (
        None
    )

    completed_on: Annotated[Optional[datetime], pydantic.Field(alias="completedOn")] = (
        None
    )

    interchange_qualification: Annotated[
        Optional[str],
        pydantic.Field(
            deprecated="warning: ** DEPRECATED ** - This will be removed in a future release, please migrate away from it as soon as possible.",
            alias="interchangeQualification",
        ),
    ] = None
    r"""The program assigned by the card network that determines the interchange rate for the transfer."""

    fee_program: Annotated[Optional[str], pydantic.Field(alias="feeProgram")] = None
    r"""The program assigned by the card network that determines the interchange rate for the transfer."""

    authorization_code: Annotated[
        Optional[str], pydantic.Field(alias="authorizationCode")
    ] = None
    r"""An alphanumeric code generated by the card network to demonstrate approval for the transaction."""
