"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .addresserror import AddressError, AddressErrorTypedDict
from .phonenumbererror import PhoneNumberError, PhoneNumberErrorTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateBusinessErrorEinTypedDict(TypedDict):
    number: NotRequired[str]


class CreateBusinessErrorEin(BaseModel):
    number: Optional[str] = None


class CreateBusinessErrorTaxIDTypedDict(TypedDict):
    ein: NotRequired[CreateBusinessErrorEinTypedDict]


class CreateBusinessErrorTaxID(BaseModel):
    ein: Optional[CreateBusinessErrorEin] = None


class CreateBusinessErrorIndustryCodesTypedDict(TypedDict):
    naics: NotRequired[str]
    sic: NotRequired[str]
    mcc: NotRequired[str]


class CreateBusinessErrorIndustryCodes(BaseModel):
    naics: Optional[str] = None

    sic: Optional[str] = None

    mcc: Optional[str] = None


class CreateBusinessErrorTypedDict(TypedDict):
    legal_business_name: NotRequired[str]
    doing_business_as: NotRequired[str]
    business_type: NotRequired[str]
    address: NotRequired[AddressErrorTypedDict]
    phone: NotRequired[PhoneNumberErrorTypedDict]
    email: NotRequired[str]
    website: NotRequired[str]
    description: NotRequired[str]
    tax_id: NotRequired[CreateBusinessErrorTaxIDTypedDict]
    industry_codes: NotRequired[CreateBusinessErrorIndustryCodesTypedDict]
    industry: NotRequired[str]
    r"""Classification identifier for the industry. Use the [GET industries](https://docs.moov.io/api/enrichment/form-shortening/industries/get/) endpoint to retrieve an array of valid industry details for a merchant, inducing all industry field values."""
    primary_regulator: NotRequired[str]


class CreateBusinessError(BaseModel):
    legal_business_name: Annotated[
        Optional[str], pydantic.Field(alias="legalBusinessName")
    ] = None

    doing_business_as: Annotated[
        Optional[str], pydantic.Field(alias="doingBusinessAs")
    ] = None

    business_type: Annotated[Optional[str], pydantic.Field(alias="businessType")] = None

    address: Optional[AddressError] = None

    phone: Optional[PhoneNumberError] = None

    email: Optional[str] = None

    website: Optional[str] = None

    description: Optional[str] = None

    tax_id: Annotated[
        Optional[CreateBusinessErrorTaxID], pydantic.Field(alias="taxID")
    ] = None

    industry_codes: Annotated[
        Optional[CreateBusinessErrorIndustryCodes],
        pydantic.Field(alias="industryCodes"),
    ] = None

    industry: Optional[str] = None
    r"""Classification identifier for the industry. Use the [GET industries](https://docs.moov.io/api/enrichment/form-shortening/industries/get/) endpoint to retrieve an array of valid industry details for a merchant, inducing all industry field values."""

    primary_regulator: Annotated[
        Optional[str], pydantic.Field(alias="primaryRegulator")
    ] = None
