"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .businesstype import BusinessType
from .industrycodes import IndustryCodes, IndustryCodesTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from .primaryregulator import PrimaryRegulator
from .taxid import TaxID, TaxIDTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateBusinessProfileTypedDict(TypedDict):
    legal_business_name: str
    r"""The legal name under which the entity is registered."""
    doing_business_as: NotRequired[str]
    r"""A registered trade name under which the business operates, if different from its legal name."""
    business_type: NotRequired[BusinessType]
    r"""The type of entity represented by this business."""
    address: NotRequired[AddressTypedDict]
    phone: NotRequired[PhoneNumberTypedDict]
    email: NotRequired[str]
    website: NotRequired[str]
    description: NotRequired[str]
    tax_id: NotRequired[TaxIDTypedDict]
    r"""An EIN (employer identification number) for the business. For sole proprietors, an SSN can be used as the EIN."""
    industry_codes: NotRequired[IndustryCodesTypedDict]
    industry: NotRequired[str]
    r"""Classification identifier for the industry. Use the [GET industries](https://docs.moov.io/api/enrichment/form-shortening/industries/get/) endpoint to retrieve an array of valid industry details for a merchant, inducing all industry field values."""
    primary_regulator: NotRequired[PrimaryRegulator]
    r"""If the business is a financial institution, this field describes its primary regulator."""


class CreateBusinessProfile(BaseModel):
    legal_business_name: Annotated[str, pydantic.Field(alias="legalBusinessName")]
    r"""The legal name under which the entity is registered."""

    doing_business_as: Annotated[
        Optional[str], pydantic.Field(alias="doingBusinessAs")
    ] = None
    r"""A registered trade name under which the business operates, if different from its legal name."""

    business_type: Annotated[
        Optional[BusinessType], pydantic.Field(alias="businessType")
    ] = None
    r"""The type of entity represented by this business."""

    address: Optional[Address] = None

    phone: Optional[PhoneNumber] = None

    email: Optional[str] = None

    website: Optional[str] = None

    description: Optional[str] = None

    tax_id: Annotated[Optional[TaxID], pydantic.Field(alias="taxID")] = None
    r"""An EIN (employer identification number) for the business. For sole proprietors, an SSN can be used as the EIN."""

    industry_codes: Annotated[
        Optional[IndustryCodes], pydantic.Field(alias="industryCodes")
    ] = None

    industry: Optional[str] = None
    r"""Classification identifier for the industry. Use the [GET industries](https://docs.moov.io/api/enrichment/form-shortening/industries/get/) endpoint to retrieve an array of valid industry details for a merchant, inducing all industry field values."""

    primary_regulator: Annotated[
        Optional[PrimaryRegulator], pydantic.Field(alias="primaryRegulator")
    ] = None
    r"""If the business is a financial institution, this field describes its primary regulator."""
