"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from .invoicelineitems import InvoiceLineItems, InvoiceLineItemsTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateInvoiceTypedDict(TypedDict):
    customer_account_id: str
    description: str
    line_items: InvoiceLineItemsTypedDict
    r"""A collection of line items for an invoice."""
    invoice_date: NotRequired[datetime]
    due_date: NotRequired[datetime]
    tax_amount: NotRequired[AmountDecimalTypedDict]


class CreateInvoice(BaseModel):
    customer_account_id: Annotated[str, pydantic.Field(alias="customerAccountID")]

    description: str

    line_items: Annotated[InvoiceLineItems, pydantic.Field(alias="lineItems")]
    r"""A collection of line items for an invoice."""

    invoice_date: Annotated[Optional[datetime], pydantic.Field(alias="invoiceDate")] = (
        None
    )

    due_date: Annotated[Optional[datetime], pydantic.Field(alias="dueDate")] = None

    tax_amount: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="taxAmount")
    ] = None
