"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .createproductoption import CreateProductOption, CreateProductOptionTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateProductOptionGroupTypedDict(TypedDict):
    name: str
    min_select: int
    r"""The minimum number of options that must be selected from this group.

    A value of 0 indicates that no selection from this group is required.
    """
    max_select: int
    r"""The maximum number of options that can be selected from this group."""
    options: List[CreateProductOptionTypedDict]
    r"""The options available within this group."""
    description: NotRequired[str]
    r"""A detailed description of the option group.

    - Must be valid UTF-8 text
    - Supports Markdown for formatting
    - HTML is not permitted and will be rejected
    """


class CreateProductOptionGroup(BaseModel):
    name: str

    min_select: Annotated[int, pydantic.Field(alias="minSelect")]
    r"""The minimum number of options that must be selected from this group.

    A value of 0 indicates that no selection from this group is required.
    """

    max_select: Annotated[int, pydantic.Field(alias="maxSelect")]
    r"""The maximum number of options that can be selected from this group."""

    options: List[CreateProductOption]
    r"""The options available within this group."""

    description: Optional[str] = None
    r"""A detailed description of the option group.

    - Must be valid UTF-8 text
    - Supports Markdown for formatting
    - HTML is not permitted and will be rejected
    """
