"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .createtransferdestination import (
    CreateTransferDestination,
    CreateTransferDestinationTypedDict,
)
from .createtransfersource import CreateTransferSource, CreateTransferSourceTypedDict
from .facilitatorfee import FacilitatorFee, FacilitatorFeeTypedDict
from .transferlineitems import TransferLineItems, TransferLineItemsTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateTransferTypedDict(TypedDict):
    source: CreateTransferSourceTypedDict
    r"""Where funds for a transfer originate. For the source, you must include either a `paymentMethodID` or a `transferID`."""
    destination: CreateTransferDestinationTypedDict
    r"""The final stage of a transfer and the ultimate recipient of the funds."""
    amount: AmountTypedDict
    facilitator_fee: NotRequired[FacilitatorFeeTypedDict]
    r"""Total or markup fee."""
    description: NotRequired[str]
    r"""An optional description of the transfer that is used on receipts and for your own internal use."""
    metadata: NotRequired[Dict[str, str]]
    r"""Free-form key-value pair list. Useful for storing information that is not captured elsewhere."""
    sales_tax_amount: NotRequired[AmountTypedDict]
    r"""Optional sales tax amount. `transfer.amount.value` should be inclusive of any sales tax and represents the total amount charged."""
    foreign_id: NotRequired[str]
    r"""Optional alias from a foreign/external system which can be used to reference this resource."""
    line_items: NotRequired[TransferLineItemsTypedDict]
    r"""An optional collection of line items for a transfer.
    When line items are provided, their total plus sales tax must equal the transfer amount.
    """


class CreateTransfer(BaseModel):
    source: CreateTransferSource
    r"""Where funds for a transfer originate. For the source, you must include either a `paymentMethodID` or a `transferID`."""

    destination: CreateTransferDestination
    r"""The final stage of a transfer and the ultimate recipient of the funds."""

    amount: Amount

    facilitator_fee: Annotated[
        Optional[FacilitatorFee], pydantic.Field(alias="facilitatorFee")
    ] = None
    r"""Total or markup fee."""

    description: Optional[str] = None
    r"""An optional description of the transfer that is used on receipts and for your own internal use."""

    metadata: Optional[Dict[str, str]] = None
    r"""Free-form key-value pair list. Useful for storing information that is not captured elsewhere."""

    sales_tax_amount: Annotated[
        Optional[Amount], pydantic.Field(alias="salesTaxAmount")
    ] = None
    r"""Optional sales tax amount. `transfer.amount.value` should be inclusive of any sales tax and represents the total amount charged."""

    foreign_id: Annotated[Optional[str], pydantic.Field(alias="foreignID")] = None
    r"""Optional alias from a foreign/external system which can be used to reference this resource."""

    line_items: Annotated[
        Optional[TransferLineItems], pydantic.Field(alias="lineItems")
    ] = None
    r"""An optional collection of line items for a transfer.
    When line items are provided, their total plus sales tax must equal the transfer amount.
    """
