"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ImageMetadataTypedDict(TypedDict):
    r"""Metadata about an uploaded image."""

    image_id: str
    public_id: str
    r"""The ID used to get an image with the public endpoint."""
    link: str
    r"""A public URL to access the image. An optional `size={width}x{height}`
    query parameter can be provided to resize the image.
    """
    created_on: datetime
    updated_on: datetime
    alt_text: NotRequired[str]
    r"""Alternative text for the image."""


class ImageMetadata(BaseModel):
    r"""Metadata about an uploaded image."""

    image_id: Annotated[str, pydantic.Field(alias="imageID")]

    public_id: Annotated[str, pydantic.Field(alias="publicID")]
    r"""The ID used to get an image with the public endpoint."""

    link: str
    r"""A public URL to access the image. An optional `size={width}x{height}`
    query parameter can be provided to resize the image.
    """

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    alt_text: Annotated[Optional[str], pydantic.Field(alias="altText")] = None
    r"""Alternative text for the image."""
