"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import io
from moovio_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from moovio_sdk.utils import FieldMetadata, MultipartFormMetadata
import pydantic
from pydantic import model_serializer
from typing import IO, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class ImageUpdateRequestMultiPartImageTypedDict(TypedDict):
    file_name: str
    content: Union[bytes, IO[bytes], io.BufferedReader]
    content_type: NotRequired[str]


class ImageUpdateRequestMultiPartImage(BaseModel):
    file_name: Annotated[
        str, pydantic.Field(alias="fileName"), FieldMetadata(multipart=True)
    ]

    content: Annotated[
        Union[bytes, IO[bytes], io.BufferedReader],
        pydantic.Field(alias=""),
        FieldMetadata(multipart=MultipartFormMetadata(content=True)),
    ]

    content_type: Annotated[
        Optional[str],
        pydantic.Field(alias="Content-Type"),
        FieldMetadata(multipart=True),
    ] = None


class MetadataTypedDict(TypedDict):
    r"""JSON-encoded metadata to update for the image.

    Omit this field if not updating metadata, or send `null` to clear existing metadata.
    """

    alt_text: NotRequired[str]
    r"""Alternative text for the image."""


class Metadata(BaseModel):
    r"""JSON-encoded metadata to update for the image.

    Omit this field if not updating metadata, or send `null` to clear existing metadata.
    """

    alt_text: Annotated[Optional[str], pydantic.Field(alias="altText")] = None
    r"""Alternative text for the image."""


class ImageUpdateRequestMultiPartTypedDict(TypedDict):
    r"""Multipart request body for updating an image and/or its metadata."""

    image: ImageUpdateRequestMultiPartImageTypedDict
    metadata: NotRequired[Nullable[MetadataTypedDict]]
    r"""JSON-encoded metadata to update for the image.

    Omit this field if not updating metadata, or send `null` to clear existing metadata.
    """


class ImageUpdateRequestMultiPart(BaseModel):
    r"""Multipart request body for updating an image and/or its metadata."""

    image: Annotated[
        ImageUpdateRequestMultiPartImage,
        FieldMetadata(multipart=MultipartFormMetadata(file=True)),
    ]

    metadata: Annotated[
        OptionalNullable[Metadata],
        FieldMetadata(multipart=MultipartFormMetadata(json=True)),
    ] = UNSET
    r"""JSON-encoded metadata to update for the image.

    Omit this field if not updating metadata, or send `null` to clear existing metadata.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["metadata"]
        nullable_fields = ["metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
