"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .imagemetadatarequest import ImageMetadataRequest, ImageMetadataRequestTypedDict
import io
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import FieldMetadata, MultipartFormMetadata
import pydantic
from typing import IO, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class ImageTypedDict(TypedDict):
    file_name: str
    content: Union[bytes, IO[bytes], io.BufferedReader]
    content_type: NotRequired[str]


class Image(BaseModel):
    file_name: Annotated[
        str, pydantic.Field(alias="fileName"), FieldMetadata(multipart=True)
    ]

    content: Annotated[
        Union[bytes, IO[bytes], io.BufferedReader],
        pydantic.Field(alias=""),
        FieldMetadata(multipart=MultipartFormMetadata(content=True)),
    ]

    content_type: Annotated[
        Optional[str],
        pydantic.Field(alias="Content-Type"),
        FieldMetadata(multipart=True),
    ] = None


class ImageUploadRequestMultiPartTypedDict(TypedDict):
    r"""Multipart request body for uploading an image with optional metadata."""

    image: ImageTypedDict
    metadata: NotRequired[ImageMetadataRequestTypedDict]
    r"""Optional, json-encoded metadata to associate with the uploaded image."""


class ImageUploadRequestMultiPart(BaseModel):
    r"""Multipart request body for uploading an image with optional metadata."""

    image: Annotated[Image, FieldMetadata(multipart=MultipartFormMetadata(file=True))]

    metadata: Annotated[
        Optional[ImageMetadataRequest],
        FieldMetadata(multipart=MultipartFormMetadata(json=True)),
    ] = None
    r"""Optional, json-encoded metadata to associate with the uploaded image."""
