"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from .generatedby import GeneratedBy, GeneratedByTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class IncurredFeeTypedDict(TypedDict):
    r"""A fee incurred by a user."""

    fee_id: NotRequired[str]
    account_id: NotRequired[str]
    wallet_id: NotRequired[str]
    created_on: NotRequired[datetime]
    fee_name: NotRequired[str]
    amount: NotRequired[AmountDecimalTypedDict]
    generated_by: NotRequired[GeneratedByTypedDict]
    r"""The entity that generated the fee."""
    fee_group: NotRequired[str]


class IncurredFee(BaseModel):
    r"""A fee incurred by a user."""

    fee_id: Annotated[Optional[str], pydantic.Field(alias="feeID")] = None

    account_id: Annotated[Optional[str], pydantic.Field(alias="accountID")] = None

    wallet_id: Annotated[Optional[str], pydantic.Field(alias="walletID")] = None

    created_on: Annotated[Optional[datetime], pydantic.Field(alias="createdOn")] = None

    fee_name: Annotated[Optional[str], pydantic.Field(alias="feeName")] = None

    amount: Optional[AmountDecimal] = None

    generated_by: Annotated[
        Optional[GeneratedBy], pydantic.Field(alias="generatedBy")
    ] = None
    r"""The entity that generated the fee."""

    fee_group: Annotated[Optional[str], pydantic.Field(alias="feeGroup")] = None
