"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class IndustryTaxonomyTypedDict(TypedDict):
    r"""A structured industry taxonomy entry with category and mapped to a default MCC code."""

    industry: str
    r"""Classification identifier for the industry."""
    display_name: str
    r"""Display name of the industry"""
    category: str
    r"""Category slug"""
    category_display_name: str
    r"""Human-readable category label"""
    default_mcc: str
    r"""Default Merchant Category Code"""


class IndustryTaxonomy(BaseModel):
    r"""A structured industry taxonomy entry with category and mapped to a default MCC code."""

    industry: str
    r"""Classification identifier for the industry."""

    display_name: Annotated[str, pydantic.Field(alias="displayName")]
    r"""Display name of the industry"""

    category: str
    r"""Category slug"""

    category_display_name: Annotated[str, pydantic.Field(alias="categoryDisplayName")]
    r"""Human-readable category label"""

    default_mcc: Annotated[str, pydantic.Field(alias="defaultMcc")]
    r"""Default Merchant Category Code"""
