"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from .invoicelineitems import InvoiceLineItems, InvoiceLineItemsTypedDict
from .invoicepayment import InvoicePayment, InvoicePaymentTypedDict
from .invoicestatus import InvoiceStatus
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class InvoiceTypedDict(TypedDict):
    invoice_id: str
    invoice_number: str
    description: str
    customer_account_id: str
    partner_account_id: str
    status: InvoiceStatus
    line_items: InvoiceLineItemsTypedDict
    r"""A collection of line items for an invoice."""
    subtotal_amount: AmountDecimalTypedDict
    tax_amount: AmountDecimalTypedDict
    total_amount: AmountDecimalTypedDict
    r"""Total amount of the invoice, sum of subTotalAmount and taxAmount"""
    pending_amount: AmountDecimalTypedDict
    r"""Total amount of pending transfers paid towards the invoice"""
    paid_amount: AmountDecimalTypedDict
    r"""Total amount of completed transfers paid towards the invoice"""
    refunded_amount: AmountDecimalTypedDict
    r"""Total amount of refunds initiated against transfers paid towards the invoice"""
    disputed_amount: AmountDecimalTypedDict
    r"""Total amount of disputes initiated against transfers paid towards the invoice"""
    created_on: datetime
    payment_link_code: NotRequired[str]
    payments: NotRequired[List[InvoicePaymentTypedDict]]
    invoice_date: NotRequired[datetime]
    due_date: NotRequired[datetime]
    sent_on: NotRequired[datetime]
    paid_on: NotRequired[datetime]
    canceled_on: NotRequired[datetime]


class Invoice(BaseModel):
    invoice_id: Annotated[str, pydantic.Field(alias="invoiceID")]

    invoice_number: Annotated[str, pydantic.Field(alias="invoiceNumber")]

    description: str

    customer_account_id: Annotated[str, pydantic.Field(alias="customerAccountID")]

    partner_account_id: Annotated[str, pydantic.Field(alias="partnerAccountID")]

    status: InvoiceStatus

    line_items: Annotated[InvoiceLineItems, pydantic.Field(alias="lineItems")]
    r"""A collection of line items for an invoice."""

    subtotal_amount: Annotated[AmountDecimal, pydantic.Field(alias="subtotalAmount")]

    tax_amount: Annotated[AmountDecimal, pydantic.Field(alias="taxAmount")]

    total_amount: Annotated[AmountDecimal, pydantic.Field(alias="totalAmount")]
    r"""Total amount of the invoice, sum of subTotalAmount and taxAmount"""

    pending_amount: Annotated[AmountDecimal, pydantic.Field(alias="pendingAmount")]
    r"""Total amount of pending transfers paid towards the invoice"""

    paid_amount: Annotated[AmountDecimal, pydantic.Field(alias="paidAmount")]
    r"""Total amount of completed transfers paid towards the invoice"""

    refunded_amount: Annotated[AmountDecimal, pydantic.Field(alias="refundedAmount")]
    r"""Total amount of refunds initiated against transfers paid towards the invoice"""

    disputed_amount: Annotated[AmountDecimal, pydantic.Field(alias="disputedAmount")]
    r"""Total amount of disputes initiated against transfers paid towards the invoice"""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    payment_link_code: Annotated[
        Optional[str], pydantic.Field(alias="paymentLinkCode")
    ] = None

    payments: Optional[List[InvoicePayment]] = None

    invoice_date: Annotated[Optional[datetime], pydantic.Field(alias="invoiceDate")] = (
        None
    )

    due_date: Annotated[Optional[datetime], pydantic.Field(alias="dueDate")] = None

    sent_on: Annotated[Optional[datetime], pydantic.Field(alias="sentOn")] = None

    paid_on: Annotated[Optional[datetime], pydantic.Field(alias="paidOn")] = None

    canceled_on: Annotated[Optional[datetime], pydantic.Field(alias="canceledOn")] = (
        None
    )
