"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from .invoicelineitemoption import InvoiceLineItemOption, InvoiceLineItemOptionTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class InvoiceLineItemTypedDict(TypedDict):
    r"""Represents a single item in an invoice, including optional modifiers and quantity."""

    name: str
    r"""The name of the item."""
    base_price: AmountDecimalTypedDict
    r"""The base price of the item before applying option modifiers."""
    quantity: int
    r"""The quantity of this item."""
    options: NotRequired[List[InvoiceLineItemOptionTypedDict]]
    r"""Optional list of modifiers applied to this item (e.g., toppings, upgrades, customizations)."""
    product_id: NotRequired[str]
    r"""Optional unique identifier associating the line item with a product."""


class InvoiceLineItem(BaseModel):
    r"""Represents a single item in an invoice, including optional modifiers and quantity."""

    name: str
    r"""The name of the item."""

    base_price: Annotated[AmountDecimal, pydantic.Field(alias="basePrice")]
    r"""The base price of the item before applying option modifiers."""

    quantity: int
    r"""The quantity of this item."""

    options: Optional[List[InvoiceLineItemOption]] = None
    r"""Optional list of modifiers applied to this item (e.g., toppings, upgrades, customizations)."""

    product_id: Annotated[Optional[str], pydantic.Field(alias="productID")] = None
    r"""Optional unique identifier associating the line item with a product."""
