"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .linkapplepaymentdata import LinkApplePaymentData, LinkApplePaymentDataTypedDict
from .linkapplepaymentmethod import (
    LinkApplePaymentMethod,
    LinkApplePaymentMethodTypedDict,
)
from moovio_sdk.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class LinkApplePayTokenTypedDict(TypedDict):
    r"""Contains the user's payment information as returned from Apple Pay.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken)
    for more information.
    """

    payment_data: LinkApplePaymentDataTypedDict
    r"""Contains the encrypted payment data.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken/1916115-paymentdata)
    for more information.
    """
    payment_method: LinkApplePaymentMethodTypedDict
    r"""Provides information about the underlying card.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken/1916113-paymentmethod)
    for more information.
    """
    transaction_identifier: str
    r"""A unique identifier provided by Apple Pay for this payment."""


class LinkApplePayToken(BaseModel):
    r"""Contains the user's payment information as returned from Apple Pay.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken)
    for more information.
    """

    payment_data: Annotated[LinkApplePaymentData, pydantic.Field(alias="paymentData")]
    r"""Contains the encrypted payment data.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken/1916115-paymentdata)
    for more information.
    """

    payment_method: Annotated[
        LinkApplePaymentMethod, pydantic.Field(alias="paymentMethod")
    ]
    r"""Provides information about the underlying card.

    Refer to [Apple's documentation](https://developer.apple.com/documentation/apple_pay_on_the_web/applepaypaymenttoken/1916113-paymentmethod)
    for more information.
    """

    transaction_identifier: Annotated[
        str, pydantic.Field(alias="transactionIdentifier")
    ]
    r"""A unique identifier provided by Apple Pay for this payment."""
