"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardaddress import CardAddress, CardAddressTypedDict
from .cardexpiration import CardExpiration, CardExpirationTypedDict
from .e2eetoken import E2EEToken, E2EETokenTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class LinkCardTypedDict(TypedDict):
    card_number: str
    card_cvv: str
    expiration: CardExpirationTypedDict
    r"""The expiration date of the card or token."""
    billing_address: CardAddressTypedDict
    e2ee: NotRequired[E2EETokenTypedDict]
    r"""Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries.
    This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our
    [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
    """
    holder_name: NotRequired[str]
    card_on_file: NotRequired[bool]
    merchant_account_id: NotRequired[str]
    verify_name: NotRequired[bool]


class LinkCard(BaseModel):
    card_number: Annotated[str, pydantic.Field(alias="cardNumber")]

    card_cvv: Annotated[str, pydantic.Field(alias="cardCvv")]

    expiration: CardExpiration
    r"""The expiration date of the card or token."""

    billing_address: Annotated[CardAddress, pydantic.Field(alias="billingAddress")]

    e2ee: Optional[E2EEToken] = None
    r"""Wraps a compact-serialized JSON Web Encryption (JWE) token used for secure transmission of sensitive data (e.g., PCI information) through intermediaries.
    This token is encrypted using the public key from /end-to-end-keys and wraps an AES key. For details and examples, refer to our
    [GitHub repository](https://github.com/moovfinancial/moov-go/blob/main/examples/e2ee/e2ee_test.go).
    """

    holder_name: Annotated[Optional[str], pydantic.Field(alias="holderName")] = None

    card_on_file: Annotated[Optional[bool], pydantic.Field(alias="cardOnFile")] = None

    merchant_account_id: Annotated[
        Optional[str], pydantic.Field(alias="merchantAccountID")
    ] = None

    verify_name: Annotated[Optional[bool], pydantic.Field(alias="verifyName")] = None
