"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .mxauthorizationcode import MXAuthorizationCode, MXAuthorizationCodeTypedDict
from moovio_sdk.types import BaseModel
from typing_extensions import TypedDict


class MxPayloadTypedDict(TypedDict):
    r"""Describes the account to link to the Moov account using a MX processor token.

    `sandbox` - When linking a bank account to a `sandbox` account using an MX authorization token a default bank account routing number will
    be used. The following default data will be used to generate the bank account in this flow:

    ```
    RoutingNumber: \"123456780\",
    BankName: \"Gringotts Bank\"
    ```
    """

    mx: MXAuthorizationCodeTypedDict
    r"""The authorization code of a MX account which allows a processor to retrieve a linked payment account.

    `sandbox` - When linking a bank account to a `sandbox` account using a MX authorization code it will utilize MX's sandbox environment.
    The MX authorization code provided must be generated from MX's sandbox environment.
    """


class MxPayload(BaseModel):
    r"""Describes the account to link to the Moov account using a MX processor token.

    `sandbox` - When linking a bank account to a `sandbox` account using an MX authorization token a default bank account routing number will
    be used. The following default data will be used to generate the bank account in this flow:

    ```
    RoutingNumber: \"123456780\",
    BankName: \"Gringotts Bank\"
    ```
    """

    mx: MXAuthorizationCode
    r"""The authorization code of a MX account which allows a processor to retrieve a linked payment account.

    `sandbox` - When linking a bank account to a `sandbox` account using a MX authorization code it will utilize MX's sandbox environment.
    The MX authorization code provided must be generated from MX's sandbox environment.
    """
