"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .billablefee import BillableFee, BillableFeeTypedDict
from .cardacquiringmodel import CardAcquiringModel
from .feeplanagreementstatus import FeePlanAgreementStatus
from .minimumcommitment import MinimumCommitment, MinimumCommitmentTypedDict
from .monthlyplatformfee import MonthlyPlatformFee, MonthlyPlatformFeeTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PartnerPricingAgreementTypedDict(TypedDict):
    agreement_id: str
    plan_id: str
    name: str
    r"""The name of the agreement."""
    accepted_on: datetime
    status: FeePlanAgreementStatus
    card_acquiring_model: CardAcquiringModel
    r"""Specifies the card processing pricing model"""
    billable_fees: List[BillableFeeTypedDict]
    minimum_commitment: MinimumCommitmentTypedDict
    r"""The minimum spending amount that must be met in the billing period. If actual usage is below the minimum amount, account is charged the difference."""
    monthly_platform_fee: MonthlyPlatformFeeTypedDict
    r"""Fixed recurring amount paid in the billing period regardless of usage."""
    revenue_share: str
    r"""The decimal-formatted numerical string of the revenue split for partner.

    For example, 2.25% is '2.25'.
    """
    account_id: NotRequired[str]
    description: NotRequired[str]
    r"""The description of the agreement."""


class PartnerPricingAgreement(BaseModel):
    agreement_id: Annotated[str, pydantic.Field(alias="agreementID")]

    plan_id: Annotated[str, pydantic.Field(alias="planID")]

    name: str
    r"""The name of the agreement."""

    accepted_on: Annotated[datetime, pydantic.Field(alias="acceptedOn")]

    status: FeePlanAgreementStatus

    card_acquiring_model: Annotated[
        CardAcquiringModel, pydantic.Field(alias="cardAcquiringModel")
    ]
    r"""Specifies the card processing pricing model"""

    billable_fees: Annotated[List[BillableFee], pydantic.Field(alias="billableFees")]

    minimum_commitment: Annotated[
        MinimumCommitment, pydantic.Field(alias="minimumCommitment")
    ]
    r"""The minimum spending amount that must be met in the billing period. If actual usage is below the minimum amount, account is charged the difference."""

    monthly_platform_fee: Annotated[
        MonthlyPlatformFee, pydantic.Field(alias="monthlyPlatformFee")
    ]
    r"""Fixed recurring amount paid in the billing period regardless of usage."""

    revenue_share: Annotated[str, pydantic.Field(alias="revenueShare")]
    r"""The decimal-formatted numerical string of the revenue split for partner.

    For example, 2.25% is '2.25'.
    """

    account_id: Annotated[Optional[str], pydantic.Field(alias="accountID")] = None

    description: Optional[str] = None
    r"""The description of the agreement."""
