"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .mode import Mode
from .paymentlinkcustomeroptions import (
    PaymentLinkCustomerOptions,
    PaymentLinkCustomerOptionsTypedDict,
)
from .paymentlinkdisplayoptions import (
    PaymentLinkDisplayOptions,
    PaymentLinkDisplayOptionsTypedDict,
)
from .paymentlinklineitems import PaymentLinkLineItems, PaymentLinkLineItemsTypedDict
from .paymentlinkpaymentdetails import (
    PaymentLinkPaymentDetails,
    PaymentLinkPaymentDetailsTypedDict,
)
from .paymentlinkpayoutdetails import (
    PaymentLinkPayoutDetails,
    PaymentLinkPayoutDetailsTypedDict,
)
from .paymentlinkstatus import PaymentLinkStatus
from .paymentlinktype import PaymentLinkType
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentLinkTypedDict(TypedDict):
    code: str
    r"""Unique code identifying this payment link."""
    payment_link_type: PaymentLinkType
    mode: Mode
    r"""The operating mode for an account."""
    status: PaymentLinkStatus
    partner_account_id: str
    r"""The partner's Moov account ID."""
    merchant_account_id: str
    r"""The merchant's Moov account ID."""
    owner_account_id: str
    r"""The payment link's owner's Moov account ID."""
    merchant_payment_method_id: str
    r"""The merchant's preferred payment method ID. Must be a wallet payment method."""
    link: str
    r"""Link to the payment landing page for this payment link."""
    amount: AmountTypedDict
    uses: int
    r"""The number of times this payment link has been used."""
    display: PaymentLinkDisplayOptionsTypedDict
    r"""Customizable display options for a payment link."""
    customer: PaymentLinkCustomerOptionsTypedDict
    created_on: datetime
    updated_on: datetime
    max_uses: NotRequired[int]
    r"""An optional limit on the number of times this payment link can be used.

    **For payouts, `maxUses` is always 1.**
    """
    last_used_on: NotRequired[datetime]
    r"""The timestamp when this payment link was last used."""
    expires_on: NotRequired[datetime]
    r"""An optional expiration date for this payment link."""
    payment: NotRequired[PaymentLinkPaymentDetailsTypedDict]
    r"""Options for payment links used to collect payment."""
    payout: NotRequired[PaymentLinkPayoutDetailsTypedDict]
    line_items: NotRequired[PaymentLinkLineItemsTypedDict]
    r"""An optional collection of line items for a payment link.
    When line items are provided, their total plus sales tax must equal the payment link amount.
    """
    disabled_on: NotRequired[datetime]


class PaymentLink(BaseModel):
    code: str
    r"""Unique code identifying this payment link."""

    payment_link_type: Annotated[
        PaymentLinkType, pydantic.Field(alias="paymentLinkType")
    ]

    mode: Mode
    r"""The operating mode for an account."""

    status: PaymentLinkStatus

    partner_account_id: Annotated[str, pydantic.Field(alias="partnerAccountID")]
    r"""The partner's Moov account ID."""

    merchant_account_id: Annotated[str, pydantic.Field(alias="merchantAccountID")]
    r"""The merchant's Moov account ID."""

    owner_account_id: Annotated[str, pydantic.Field(alias="ownerAccountID")]
    r"""The payment link's owner's Moov account ID."""

    merchant_payment_method_id: Annotated[
        str, pydantic.Field(alias="merchantPaymentMethodID")
    ]
    r"""The merchant's preferred payment method ID. Must be a wallet payment method."""

    link: str
    r"""Link to the payment landing page for this payment link."""

    amount: Amount

    uses: int
    r"""The number of times this payment link has been used."""

    display: PaymentLinkDisplayOptions
    r"""Customizable display options for a payment link."""

    customer: PaymentLinkCustomerOptions

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    max_uses: Annotated[Optional[int], pydantic.Field(alias="maxUses")] = None
    r"""An optional limit on the number of times this payment link can be used.

    **For payouts, `maxUses` is always 1.**
    """

    last_used_on: Annotated[Optional[datetime], pydantic.Field(alias="lastUsedOn")] = (
        None
    )
    r"""The timestamp when this payment link was last used."""

    expires_on: Annotated[Optional[datetime], pydantic.Field(alias="expiresOn")] = None
    r"""An optional expiration date for this payment link."""

    payment: Optional[PaymentLinkPaymentDetails] = None
    r"""Options for payment links used to collect payment."""

    payout: Optional[PaymentLinkPayoutDetails] = None

    line_items: Annotated[
        Optional[PaymentLinkLineItems], pydantic.Field(alias="lineItems")
    ] = None
    r"""An optional collection of line items for a payment link.
    When line items are provided, their total plus sales tax must equal the payment link amount.
    """

    disabled_on: Annotated[Optional[datetime], pydantic.Field(alias="disabledOn")] = (
        None
    )
