"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .calltoaction import CallToAction
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentLinkDisplayOptionsUpdateTypedDict(TypedDict):
    r"""Customizable display options for a payment link."""

    title: NotRequired[str]
    r"""The payment page title displayed to the user."""
    description: NotRequired[str]
    r"""A payment description displayed to the user."""
    call_to_action: NotRequired[CallToAction]
    r"""The text to be displayed on web form's submit button.

    If set to \"auto\" the UI will automatically select between
    \"pay\" and \"confirm\" for payments and payouts respectively.
    """


class PaymentLinkDisplayOptionsUpdate(BaseModel):
    r"""Customizable display options for a payment link."""

    title: Optional[str] = None
    r"""The payment page title displayed to the user."""

    description: Optional[str] = None
    r"""A payment description displayed to the user."""

    call_to_action: Annotated[
        Optional[CallToAction], pydantic.Field(alias="callToAction")
    ] = None
    r"""The text to be displayed on web form's submit button.

    If set to \"auto\" the UI will automatically select between
    \"pay\" and \"confirm\" for payments and payouts respectively.
    """
