"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from .paymentlinklineitemimagemetadata import (
    PaymentLinkLineItemImageMetadata,
    PaymentLinkLineItemImageMetadataTypedDict,
)
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentLinkLineItemOptionTypedDict(TypedDict):
    r"""Represents a modifier or option applied to a line item."""

    name: str
    r"""The name of the option or modifier."""
    quantity: int
    r"""The quantity of this option."""
    price_modifier: NotRequired[AmountDecimalTypedDict]
    r"""Optional price modification applied by this option. Can be positive, negative, or zero."""
    images: NotRequired[List[PaymentLinkLineItemImageMetadataTypedDict]]
    r"""Optional list of images associated with this line item option."""
    group: NotRequired[str]
    r"""Optional group identifier to categorize related options (e.g., 'toppings')."""


class PaymentLinkLineItemOption(BaseModel):
    r"""Represents a modifier or option applied to a line item."""

    name: str
    r"""The name of the option or modifier."""

    quantity: int
    r"""The quantity of this option."""

    price_modifier: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="priceModifier")
    ] = None
    r"""Optional price modification applied by this option. Can be positive, negative, or zero."""

    images: Optional[List[PaymentLinkLineItemImageMetadata]] = None
    r"""Optional list of images associated with this line item option."""

    group: Optional[str] = None
    r"""Optional group identifier to categorize related options (e.g., 'toppings')."""
