"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .achpaymentdetails import ACHPaymentDetails, ACHPaymentDetailsTypedDict
from .cardpaymentdetails import CardPaymentDetails, CardPaymentDetailsTypedDict
from .collectionpaymentmethodtype import CollectionPaymentMethodType
from moovio_sdk.types import BaseModel
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentLinkPaymentDetailsUpdateTypedDict(TypedDict):
    r"""Options for payment links used to collect payment."""

    allowed_methods: NotRequired[List[CollectionPaymentMethodType]]
    r"""A list of payment methods that should be supported for this payment link."""
    card_details: NotRequired[CardPaymentDetailsTypedDict]
    r"""Options for payment links used to collect a card payment."""
    ach_details: NotRequired[ACHPaymentDetailsTypedDict]
    r"""Options for payment links used to collect an ACH payment."""
    metadata: NotRequired[Dict[str, str]]
    r"""Optional free-form metadata for the transfer."""


class PaymentLinkPaymentDetailsUpdate(BaseModel):
    r"""Options for payment links used to collect payment."""

    allowed_methods: Annotated[
        Optional[List[CollectionPaymentMethodType]],
        pydantic.Field(alias="allowedMethods"),
    ] = None
    r"""A list of payment methods that should be supported for this payment link."""

    card_details: Annotated[
        Optional[CardPaymentDetails], pydantic.Field(alias="cardDetails")
    ] = None
    r"""Options for payment links used to collect a card payment."""

    ach_details: Annotated[
        Optional[ACHPaymentDetails], pydantic.Field(alias="achDetails")
    ] = None
    r"""Options for payment links used to collect an ACH payment."""

    metadata: Optional[Dict[str, str]] = None
    r"""Optional free-form metadata for the transfer."""
