"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .disbursementpaymentmethodtype import DisbursementPaymentMethodType
from .payoutrecipient import PayoutRecipient, PayoutRecipientTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentLinkPayoutDetailsTypedDict(TypedDict):
    allowed_methods: List[DisbursementPaymentMethodType]
    r"""A list of payment methods that should be supported for this payment link."""
    recipient: PayoutRecipientTypedDict
    r"""Specify the intended recipient of the payout.
    Either `email` or `phone` must be specified, but not both.

    This information will be used to authenticate the end user when they follow the payment link.
    """
    metadata: NotRequired[Dict[str, str]]
    r"""Optional free-form metadata for the transfer."""


class PaymentLinkPayoutDetails(BaseModel):
    allowed_methods: Annotated[
        List[DisbursementPaymentMethodType], pydantic.Field(alias="allowedMethods")
    ]
    r"""A list of payment methods that should be supported for this payment link."""

    recipient: PayoutRecipient
    r"""Specify the intended recipient of the payout.
    Either `email` or `phone` must be specified, but not both.

    This information will be used to authenticate the end user when they follow the payment link.
    """

    metadata: Optional[Dict[str, str]] = None
    r"""Optional free-form metadata for the transfer."""
