"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .disbursementpaymentmethodtype import DisbursementPaymentMethodType
from .payoutrecipient import PayoutRecipient, PayoutRecipientTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentLinkPayoutDetailsUpdateTypedDict(TypedDict):
    allowed_methods: NotRequired[List[DisbursementPaymentMethodType]]
    r"""A list of payment methods that should be supported for this payment link."""
    recipient: NotRequired[PayoutRecipientTypedDict]
    r"""Specify the intended recipient of the payout.
    Either `email` or `phone` must be specified, but not both.

    This information will be used to authenticate the end user when they follow the payment link.
    """
    metadata: NotRequired[Dict[str, str]]
    r"""Optional free-form metadata for the transfer."""


class PaymentLinkPayoutDetailsUpdate(BaseModel):
    allowed_methods: Annotated[
        Optional[List[DisbursementPaymentMethodType]],
        pydantic.Field(alias="allowedMethods"),
    ] = None
    r"""A list of payment methods that should be supported for this payment link."""

    recipient: Optional[PayoutRecipient] = None
    r"""Specify the intended recipient of the payout.
    Either `email` or `phone` must be specified, but not both.

    This information will be used to authenticate the end user when they follow the payment link.
    """

    metadata: Optional[Dict[str, str]] = None
    r"""Optional free-form metadata for the transfer."""
