"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .bankaccountholdertype import BankAccountHolderType
from .bankaccountstatus import BankAccountStatus
from .bankaccounttype import BankAccountType
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class PaymentMethodsBankAccountTypedDict(TypedDict):
    r"""A bank account as contained within a payment method."""

    bank_account_id: str
    fingerprint: str
    r"""Once the bank account is linked, we don't reveal the full bank account number.

    The fingerprint acts as a way to identify whether two linked bank accounts are the same.
    """
    status: BankAccountStatus
    holder_name: str
    holder_type: BankAccountHolderType
    r"""The type of holder on a funding source."""
    bank_name: str
    bank_account_type: BankAccountType
    r"""The bank account type."""
    routing_number: str
    last_four_account_number: str
    updated_on: datetime


class PaymentMethodsBankAccount(BaseModel):
    r"""A bank account as contained within a payment method."""

    bank_account_id: Annotated[str, pydantic.Field(alias="bankAccountID")]

    fingerprint: str
    r"""Once the bank account is linked, we don't reveal the full bank account number.

    The fingerprint acts as a way to identify whether two linked bank accounts are the same.
    """

    status: BankAccountStatus

    holder_name: Annotated[str, pydantic.Field(alias="holderName")]

    holder_type: Annotated[BankAccountHolderType, pydantic.Field(alias="holderType")]
    r"""The type of holder on a funding source."""

    bank_name: Annotated[str, pydantic.Field(alias="bankName")]

    bank_account_type: Annotated[
        BankAccountType, pydantic.Field(alias="bankAccountType")
    ]
    r"""The bank account type."""

    routing_number: Annotated[str, pydantic.Field(alias="routingNumber")]

    last_four_account_number: Annotated[
        str, pydantic.Field(alias="lastFourAccountNumber")
    ]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]
