"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from .productimagemetadata import ProductImageMetadata, ProductImageMetadataTypedDict
from .productoptiongroup import ProductOptionGroup, ProductOptionGroupTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ProductTypedDict(TypedDict):
    r"""A product available for purchase, which may have optional configuration options."""

    product_id: str
    r"""Unique identifier for a product."""
    title: str
    base_price: AmountDecimalTypedDict
    r"""A product's starting price, before applying modifiers."""
    created_on: datetime
    r"""The date and time when the product was added."""
    updated_on: datetime
    r"""The date and time when the product was last updated."""
    description: NotRequired[str]
    r"""A detailed description of the product.

    - Must be valid UTF-8 text
    - Supports Markdown for formatting
    - HTML is not permitted and will be rejected
    """
    option_groups: NotRequired[List[ProductOptionGroupTypedDict]]
    r"""Optional configuration options for a product, such as size or color."""
    images: NotRequired[List[ProductImageMetadataTypedDict]]
    r"""Optional images associated with the product."""
    disabled_on: NotRequired[datetime]
    r"""The date and time when the product was disabled."""


class Product(BaseModel):
    r"""A product available for purchase, which may have optional configuration options."""

    product_id: Annotated[str, pydantic.Field(alias="productID")]
    r"""Unique identifier for a product."""

    title: str

    base_price: Annotated[AmountDecimal, pydantic.Field(alias="basePrice")]
    r"""A product's starting price, before applying modifiers."""

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]
    r"""The date and time when the product was added."""

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]
    r"""The date and time when the product was last updated."""

    description: Optional[str] = None
    r"""A detailed description of the product.

    - Must be valid UTF-8 text
    - Supports Markdown for formatting
    - HTML is not permitted and will be rejected
    """

    option_groups: Annotated[
        Optional[List[ProductOptionGroup]], pydantic.Field(alias="optionGroups")
    ] = None
    r"""Optional configuration options for a product, such as size or color."""

    images: Optional[List[ProductImageMetadata]] = None
    r"""Optional images associated with the product."""

    disabled_on: Annotated[Optional[datetime], pydantic.Field(alias="disabledOn")] = (
        None
    )
    r"""The date and time when the product was disabled."""
