"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from .productimagemetadata import ProductImageMetadata, ProductImageMetadataTypedDict
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ProductOptionTypedDict(TypedDict):
    r"""Represents a single product option within a group."""

    name: str
    r"""The display name of a product option."""
    description: NotRequired[str]
    r"""A detailed description of the option.

    - Must be valid UTF-8 text
    - Supports Markdown for formatting
    - HTML is not permitted and will be rejected
    """
    price_modifier: NotRequired[AmountDecimalTypedDict]
    r"""The adjustment applied to a product's base price by this option. Can be negative, positive, or zero."""
    images: NotRequired[List[ProductImageMetadataTypedDict]]
    r"""The images associated with this option."""


class ProductOption(BaseModel):
    r"""Represents a single product option within a group."""

    name: str
    r"""The display name of a product option."""

    description: Optional[str] = None
    r"""A detailed description of the option.

    - Must be valid UTF-8 text
    - Supports Markdown for formatting
    - HTML is not permitted and will be rejected
    """

    price_modifier: Annotated[
        Optional[AmountDecimal], pydantic.Field(alias="priceModifier")
    ] = None
    r"""The adjustment applied to a product's base price by this option. Can be negative, positive, or zero."""

    images: Optional[List[ProductImageMetadata]] = None
    r"""The images associated with this option."""
