"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from .assignproductimage import AssignProductImage, AssignProductImageTypedDict
from .createproductoptiongroup import (
    CreateProductOptionGroup,
    CreateProductOptionGroupTypedDict,
)
from moovio_sdk.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ProductRequestTypedDict(TypedDict):
    r"""Request to create or update a product."""

    title: str
    base_price: AmountDecimalTypedDict
    r"""A product's starting price, before applying modifiers."""
    description: NotRequired[str]
    r"""A detailed description of the product.

    - Must be valid UTF-8 text
    - Supports Markdown for formatting
    - HTML is not permitted and will be rejected
    """
    images: NotRequired[List[AssignProductImageTypedDict]]
    r"""Assign previously uploaded images to a product or option."""
    option_groups: NotRequired[List[CreateProductOptionGroupTypedDict]]
    r"""Optional configuration options for a product, such as size or color."""


class ProductRequest(BaseModel):
    r"""Request to create or update a product."""

    title: str

    base_price: Annotated[AmountDecimal, pydantic.Field(alias="basePrice")]
    r"""A product's starting price, before applying modifiers."""

    description: Optional[str] = None
    r"""A detailed description of the product.

    - Must be valid UTF-8 text
    - Supports Markdown for formatting
    - HTML is not permitted and will be rejected
    """

    images: Optional[List[AssignProductImage]] = None
    r"""Assign previously uploaded images to a product or option."""

    option_groups: Annotated[
        Optional[List[CreateProductOptionGroup]], pydantic.Field(alias="optionGroups")
    ] = None
    r"""Optional configuration options for a product, such as size or color."""
