"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .address import Address, AddressTypedDict
from .individualname import IndividualName, IndividualNameTypedDict
from .phonenumber import PhoneNumber, PhoneNumberTypedDict
from .representativeresponsibilities import (
    RepresentativeResponsibilities,
    RepresentativeResponsibilitiesTypedDict,
)
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class RepresentativeTypedDict(TypedDict):
    r"""Describes a business representative."""

    representative_id: str
    r"""Unique identifier for this representative."""
    name: IndividualNameTypedDict
    created_on: datetime
    updated_on: datetime
    phone: NotRequired[PhoneNumberTypedDict]
    email: NotRequired[str]
    address: NotRequired[AddressTypedDict]
    birth_date_provided: NotRequired[bool]
    r"""Indicates whether this representative's birth date has been provided."""
    government_id_provided: NotRequired[bool]
    r"""Indicates whether a government ID (SSN, ITIN, etc.) has been provided for this representative."""
    responsibilities: NotRequired[RepresentativeResponsibilitiesTypedDict]
    r"""Describes the job responsibilities of a business representative."""
    disabled_on: NotRequired[datetime]


class Representative(BaseModel):
    r"""Describes a business representative."""

    representative_id: Annotated[str, pydantic.Field(alias="representativeID")]
    r"""Unique identifier for this representative."""

    name: IndividualName

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]

    phone: Optional[PhoneNumber] = None

    email: Optional[str] = None

    address: Optional[Address] = None

    birth_date_provided: Annotated[
        Optional[bool], pydantic.Field(alias="birthDateProvided")
    ] = None
    r"""Indicates whether this representative's birth date has been provided."""

    government_id_provided: Annotated[
        Optional[bool], pydantic.Field(alias="governmentIDProvided")
    ] = None
    r"""Indicates whether a government ID (SSN, ITIN, etc.) has been provided for this representative."""

    responsibilities: Optional[RepresentativeResponsibilities] = None
    r"""Describes the job responsibilities of a business representative."""

    disabled_on: Annotated[Optional[datetime], pydantic.Field(alias="disabledOn")] = (
        None
    )
