"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimal import AmountDecimal, AmountDecimalTypedDict
from datetime import datetime
from moovio_sdk.types import BaseModel
import pydantic
from typing_extensions import Annotated, TypedDict


class ResidualTypedDict(TypedDict):
    residual_id: str
    partner_account_id: str
    period_start: datetime
    period_end: datetime
    merchant_fees: AmountDecimalTypedDict
    partner_cost: AmountDecimalTypedDict
    net_income: AmountDecimalTypedDict
    revenue_share: str
    r"""The decimal-formatted numerical string of the revenue split for partner.

    For example, 2.25% is '2.25'.
    """
    residual_amount: AmountDecimalTypedDict
    moov_share: AmountDecimalTypedDict
    created_on: datetime
    updated_on: datetime


class Residual(BaseModel):
    residual_id: Annotated[str, pydantic.Field(alias="residualID")]

    partner_account_id: Annotated[str, pydantic.Field(alias="partnerAccountID")]

    period_start: Annotated[datetime, pydantic.Field(alias="periodStart")]

    period_end: Annotated[datetime, pydantic.Field(alias="periodEnd")]

    merchant_fees: Annotated[AmountDecimal, pydantic.Field(alias="merchantFees")]

    partner_cost: Annotated[AmountDecimal, pydantic.Field(alias="partnerCost")]

    net_income: Annotated[AmountDecimal, pydantic.Field(alias="netIncome")]

    revenue_share: Annotated[str, pydantic.Field(alias="revenueShare")]
    r"""The decimal-formatted numerical string of the revenue split for partner.

    For example, 2.25% is '2.25'.
    """

    residual_amount: Annotated[AmountDecimal, pydantic.Field(alias="residualAmount")]

    moov_share: Annotated[AmountDecimal, pydantic.Field(alias="moovShare")]

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    updated_on: Annotated[datetime, pydantic.Field(alias="updatedOn")]
