"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .cardbrand import CardBrand
from .cardexpiration import CardExpiration, CardExpirationTypedDict
from .cardtype import CardType
from .entrymode import EntryMode
from moovio_sdk.types import BaseModel
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TerminalCardTypedDict(TypedDict):
    r"""Describes payment card details captured with tap or in-person payment."""

    entry_mode: NotRequired[EntryMode]
    r"""How the card information was entered into the point of sale terminal."""
    brand: NotRequired[CardBrand]
    r"""The card brand."""
    bin: NotRequired[str]
    card_type: NotRequired[CardType]
    r"""The type of the card."""
    expiration: NotRequired[CardExpirationTypedDict]
    r"""The expiration date of the card or token."""
    fingerprint: NotRequired[str]
    r"""Uniquely identifies a linked payment card or token.
    For Apple Pay, the fingerprint is based on the tokenized card number and may vary based on the user's device.
    This field can be used to identify specific payment methods across multiple accounts on your platform.
    """
    holder_name: NotRequired[str]
    r"""The name of the cardholder as it appears on the card."""
    issuer: NotRequired[str]
    r"""Financial institution that issued the card."""
    issuer_country: NotRequired[str]
    r"""Country where the card was issued."""
    last_four_card_number: NotRequired[str]
    r"""Last four digits of the card number"""
    application_id: NotRequired[str]
    r"""Identifier for the point of sale terminal application."""
    application_name: NotRequired[str]
    r"""Name label for the point of sale terminal application."""


class TerminalCard(BaseModel):
    r"""Describes payment card details captured with tap or in-person payment."""

    entry_mode: Annotated[Optional[EntryMode], pydantic.Field(alias="entryMode")] = None
    r"""How the card information was entered into the point of sale terminal."""

    brand: Optional[CardBrand] = None
    r"""The card brand."""

    bin: Optional[str] = None

    card_type: Annotated[Optional[CardType], pydantic.Field(alias="cardType")] = None
    r"""The type of the card."""

    expiration: Optional[CardExpiration] = None
    r"""The expiration date of the card or token."""

    fingerprint: Optional[str] = None
    r"""Uniquely identifies a linked payment card or token.
    For Apple Pay, the fingerprint is based on the tokenized card number and may vary based on the user's device.
    This field can be used to identify specific payment methods across multiple accounts on your platform.
    """

    holder_name: Annotated[Optional[str], pydantic.Field(alias="holderName")] = None
    r"""The name of the cardholder as it appears on the card."""

    issuer: Optional[str] = None
    r"""Financial institution that issued the card."""

    issuer_country: Annotated[Optional[str], pydantic.Field(alias="issuerCountry")] = (
        None
    )
    r"""Country where the card was issued."""

    last_four_card_number: Annotated[
        Optional[str], pydantic.Field(alias="lastFourCardNumber")
    ] = None
    r"""Last four digits of the card number"""

    application_id: Annotated[Optional[str], pydantic.Field(alias="applicationID")] = (
        None
    )
    r"""Identifier for the point of sale terminal application."""

    application_name: Annotated[
        Optional[str], pydantic.Field(alias="applicationName")
    ] = None
    r"""Name label for the point of sale terminal application."""
