"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amountdecimalupdate import AmountDecimalUpdate, AmountDecimalUpdateTypedDict
from .invoicelineitemsupdate import (
    InvoiceLineItemsUpdate,
    InvoiceLineItemsUpdateTypedDict,
)
from .invoicestatus import InvoiceStatus
from datetime import datetime
from moovio_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateInvoiceTypedDict(TypedDict):
    description: NotRequired[str]
    line_items: NotRequired[InvoiceLineItemsUpdateTypedDict]
    r"""A collection of line items for an invoice."""
    invoice_date: NotRequired[Nullable[datetime]]
    due_date: NotRequired[Nullable[datetime]]
    status: NotRequired[InvoiceStatus]
    r"""Status can only be updated to `canceled` when the status is either `draft`, `unpaid`,  or `overdue`."""
    tax_amount: NotRequired[AmountDecimalUpdateTypedDict]


class UpdateInvoice(BaseModel):
    description: Optional[str] = None

    line_items: Annotated[
        Optional[InvoiceLineItemsUpdate], pydantic.Field(alias="lineItems")
    ] = None
    r"""A collection of line items for an invoice."""

    invoice_date: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="invoiceDate")
    ] = UNSET

    due_date: Annotated[OptionalNullable[datetime], pydantic.Field(alias="dueDate")] = (
        UNSET
    )

    status: Optional[InvoiceStatus] = None
    r"""Status can only be updated to `canceled` when the status is either `draft`, `unpaid`,  or `overdue`."""

    tax_amount: Annotated[
        Optional[AmountDecimalUpdate], pydantic.Field(alias="taxAmount")
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "lineItems",
            "invoiceDate",
            "dueDate",
            "status",
            "taxAmount",
        ]
        nullable_fields = ["invoiceDate", "dueDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
